/*:
 * @target MZ
 * @plugindesc Overlay中はコモンイベント予約を禁止（バックログ／オプション中の「あとで実行される」を防ぐ）
 * @author HS
 *
 * @param applyToBacklog
 * @text バックログ中に禁止
 * @type boolean
 * @default true
 *
 * @param applyToOptions
 * @text オプション重ね表示中に禁止
 * @type boolean
 * @default true
 */
(() => {
  'use strict';
  const PN = document.currentScript.src.split('/').pop().replace(/\.js$/,'');
  const P  = PluginManager.parameters(PN);
  const APPLY_BL = P.applyToBacklog !== 'false';
  const APPLY_OP = P.applyToOptions !== 'false';

  const isBacklogOpen = () => !!(window.HSBL && typeof HSBL.isOpen === 'function' && HSBL.isOpen());
  const isOptionsOpen = () => !!(window.HS && typeof HS.isOptionsOverlayOpen === 'function' && HS.isOptionsOverlayOpen());

  const overlayActive = () => (APPLY_BL && isBacklogOpen()) || (APPLY_OP && isOptionsOpen());

  // どのプラグインから呼ばれても、Overlay中は予約させない
  const _reserveCE = Game_Temp.prototype.reserveCommonEvent;
  Game_Temp.prototype.reserveCommonEvent = function(commonEventId) {
    if (overlayActive()) return;              // ← 予約自体を捨てる
    return _reserveCE.apply(this, arguments);
  };

  // ButtonPicture の onClick 入口も安全側へ（存在すれば）
  const _BP_onClick = Sprite_Picture.prototype.onClick;
  Sprite_Picture.prototype.onClick = function() {
    if (overlayActive()) return;              // ← 念のためこちらでも弾く
    if (_BP_onClick) _BP_onClick.apply(this, arguments);
  };

  // 念のため、閉じた瞬間に古い予約キューがあれば掃除（安全運転）
  let prevActive = false;
  const _SceneBase_update = Scene_Base.prototype.update;
  Scene_Base.prototype.update = function() {
    _SceneBase_update.apply(this, arguments);
    const nowActive = overlayActive();
    if (prevActive && !nowActive) {
      // Overlayを閉じたフレーム。残存キューがあれば消す（ButtonPicture系で独自キューを使う対策）
      try {
        if (Array.isArray($gameTemp._commonEventQueue)) $gameTemp._commonEventQueue.length = 0;
      } catch(_) {}
    }
    prevActive = nowActive;
  };

  // 他からも参照できるヘルパ（デバッグ用）
  window.HS = window.HS || {};
  HS.isUiOverlayBlocking = overlayActive;
})();
